<?php
/**
 * Database Schema Verification Script
 * Checks if all required tables and columns exist for the UI
 */

// Auto-detect environment
$isProduction = isset($_SERVER['HTTP_HOST']) && (
    strpos($_SERVER['HTTP_HOST'], 'ceiscy.com') !== false ||
    strpos($_SERVER['HTTP_HOST'], 'pcg.campus-plug.com') !== false
);

if ($isProduction) {
    $servername = "localhost";
    $username = "campuspl_pcg";
    $password = "pcgcctt@30";
    $dbname = "campuspl_dgsch";
} else {
    $servername = "localhost";
    $username = "root";
    $password = "";
    $dbname = "divine_grace_school";
}

try {
    $conn = new PDO("mysql:host=$servername;dbname=$dbname", $username, $password);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    echo "<h2>Database Schema Verification</h2>";
    echo "<p>Database: <strong>$dbname</strong></p>";
    
    // Define required schema
    $requiredSchema = [
        'students' => [
            'id', 'student_id', 'first_name', 'last_name', 'date_of_birth', 
            'gender', 'class', 'section', 'admission_date', 'father_name', 
            'mother_name', 'phone_number', 'address', 'city', 'state', 
            'pincode', 'status', 'created_at', 'updated_at'
        ],
        'fees' => [
            'id', 'student_id', 'fee_type', 'amount', 'due_date', 'status',
            'payment_date', 'payment_method', 'transaction_id', 'discount',
            'fine', 'notes', 'original_amount', 'student_name', 'student_id_num',
            'description', 'academic_year', 'term', 'recorded_by', 'is_active',
            'deleted_at', 'created_at', 'updated_at'
        ],
        'users' => [
            'id', 'username', 'password', 'email', 'full_name', 'role',
            'last_login', 'status', 'is_active', 'phone', 'created_at', 'updated_at'
        ],
        'expenses' => [
            'id', 'category', 'amount', 'expense_date', 'description',
            'payment_method', 'reference_number', 'created_by', 'created_at', 'updated_at'
        ],
        'income' => [
            'id', 'source', 'amount', 'income_date', 'description',
            'payment_method', 'reference_number', 'received_by', 'created_at', 'updated_at'
        ],
        'class_feeding_fees' => [
            'id', 'class_name', 'daily_fee', 'created_at', 'updated_at'
        ],
        'feeding_records' => [
            'id', 'student_id', 'student_name', 'class_name', 'feeding_date',
            'is_present', 'has_paid', 'amount_paid', 'recorded_by', 'created_at', 'updated_at'
        ]
    ];
    
    $allGood = true;
    
    // Check each table
    foreach ($requiredSchema as $table => $columns) {
        echo "<h3>Table: $table</h3>";
        
        // Check if table exists
        $stmt = $conn->query("SHOW TABLES LIKE '$table'");
        if ($stmt->rowCount() == 0) {
            echo "<p style='color: red;'>❌ Table '$table' does NOT exist!</p>";
            $allGood = false;
            continue;
        }
        
        echo "<p style='color: green;'>✅ Table exists</p>";
        
        // Get existing columns
        $stmt = $conn->query("SHOW COLUMNS FROM $table");
        $existingColumns = $stmt->fetchAll(PDO::FETCH_COLUMN);
        
        // Check each required column
        $missingColumns = [];
        foreach ($columns as $column) {
            if (!in_array($column, $existingColumns)) {
                $missingColumns[] = $column;
            }
        }
        
        if (empty($missingColumns)) {
            echo "<p style='color: green;'>✅ All required columns present</p>";
        } else {
            echo "<p style='color: orange;'>⚠️ Missing columns: " . implode(', ', $missingColumns) . "</p>";
            $allGood = false;
        }
        
        // Show column count
        echo "<p>Columns: " . count($existingColumns) . " found, " . count($columns) . " required</p>";
    }
    
    echo "<hr>";
    
    if ($allGood) {
        echo "<h2 style='color: green;'>✅ Database schema is complete!</h2>";
        echo "<p>All required tables and columns are present.</p>";
    } else {
        echo "<h2 style='color: orange;'>⚠️ Database schema needs updates</h2>";
        echo "<p>Please run the following scripts in order:</p>";
        echo "<ol>";
        echo "<li><a href='init_database.php'>init_database.php</a> - Create base tables</li>";
        echo "<li><a href='../setup_feeding_tables.php'>setup_feeding_tables.php</a> - Create feeding tables</li>";
        echo "<li><a href='migrate_add_user_fields.php'>migrate_add_user_fields.php</a> - Add user fields</li>";
        echo "<li><a href='migrate_add_payment_fields.php'>migrate_add_payment_fields.php</a> - Add payment fields</li>";
        echo "<li><a href='migrate_add_fee_columns.php'>migrate_add_fee_columns.php</a> - Add fee columns</li>";
        echo "</ol>";
    }
    
    // Show record counts
    echo "<hr>";
    echo "<h3>Record Counts</h3>";
    echo "<ul>";
    foreach (array_keys($requiredSchema) as $table) {
        try {
            $stmt = $conn->query("SELECT COUNT(*) as count FROM $table");
            $count = $stmt->fetch(PDO::FETCH_ASSOC)['count'];
            echo "<li><strong>$table:</strong> $count records</li>";
        } catch (Exception $e) {
            echo "<li><strong>$table:</strong> <span style='color: red;'>Error: " . $e->getMessage() . "</span></li>";
        }
    }
    echo "</ul>";
    
} catch(PDOException $e) {
    echo "<h2 style='color: red;'>❌ Database Connection Error</h2>";
    echo "<p>" . $e->getMessage() . "</p>";
}
?>
