<?php
/**
 * Migration: Add payment tracking fields to fees table
 * Run this file once to add the missing columns
 */

// Production Database configuration
$host = 'localhost';
$db_name = 'campuspl_dgsch';
$username = 'campuspl_pcg';
$password = 'pcgcctt@30';

try {
    // Create PDO connection
    $conn = new PDO(
        "mysql:host=$host;dbname=$db_name;charset=utf8mb4",
        $username,
        $password,
        [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
        ]
    );
    
    echo "Starting migration: Add payment fields to fees table...\n\n";
    
    // Check if columns already exist
    $stmt = $conn->query("SHOW COLUMNS FROM fees LIKE 'amount_paid'");
    $amountPaidExists = $stmt->rowCount() > 0;
    
    $stmt = $conn->query("SHOW COLUMNS FROM fees LIKE 'balance'");
    $balanceExists = $stmt->rowCount() > 0;
    
    $stmt = $conn->query("SHOW COLUMNS FROM fees LIKE 'payment_date'");
    $paymentDateExists = $stmt->rowCount() > 0;
    
    $stmt = $conn->query("SHOW COLUMNS FROM fees LIKE 'payment_method'");
    $paymentMethodExists = $stmt->rowCount() > 0;
    
    $stmt = $conn->query("SHOW COLUMNS FROM fees LIKE 'payment_history'");
    $paymentHistoryExists = $stmt->rowCount() > 0;
    
    // Add amount_paid column
    if (!$amountPaidExists) {
        echo "Adding 'amount_paid' column...\n";
        $conn->exec("ALTER TABLE fees ADD COLUMN amount_paid DECIMAL(10,2) DEFAULT 0.00 AFTER amount");
        echo "✓ Added 'amount_paid' column\n\n";
    } else {
        echo "✓ 'amount_paid' column already exists\n\n";
    }
    
    // Add balance column
    if (!$balanceExists) {
        echo "Adding 'balance' column...\n";
        $conn->exec("ALTER TABLE fees ADD COLUMN balance DECIMAL(10,2) DEFAULT 0.00 AFTER amount_paid");
        echo "✓ Added 'balance' column\n\n";
    } else {
        echo "✓ 'balance' column already exists\n\n";
    }
    
    // Add payment_date column
    if (!$paymentDateExists) {
        echo "Adding 'payment_date' column...\n";
        $conn->exec("ALTER TABLE fees ADD COLUMN payment_date DATE NULL AFTER status");
        echo "✓ Added 'payment_date' column\n\n";
    } else {
        echo "✓ 'payment_date' column already exists\n\n";
    }
    
    // Add payment_method column
    if (!$paymentMethodExists) {
        echo "Adding 'payment_method' column...\n";
        $conn->exec("ALTER TABLE fees ADD COLUMN payment_method VARCHAR(50) NULL AFTER payment_date");
        echo "✓ Added 'payment_method' column\n\n";
    } else {
        echo "✓ 'payment_method' column already exists\n\n";
    }
    
    // Add payment_history column
    if (!$paymentHistoryExists) {
        echo "Adding 'payment_history' column...\n";
        $conn->exec("ALTER TABLE fees ADD COLUMN payment_history TEXT NULL AFTER payment_method");
        echo "✓ Added 'payment_history' column\n\n";
    } else {
        echo "✓ 'payment_history' column already exists\n\n";
    }
    
    // Update existing fees to set balance = amount - amount_paid
    echo "Updating existing fees to calculate balance...\n";
    $conn->exec("UPDATE fees SET balance = amount - amount_paid - COALESCE(scholarship_amount, 0) WHERE balance IS NULL OR balance = 0");
    echo "✓ Updated balances for existing fees\n\n";
    
    // Update status based on balance
    echo "Updating fee statuses based on balance...\n";
    $conn->exec("UPDATE fees SET status = 'paid' WHERE balance <= 0 AND amount_paid > 0");
    $conn->exec("UPDATE fees SET status = 'partial' WHERE balance > 0 AND amount_paid > 0");
    $conn->exec("UPDATE fees SET status = 'unpaid' WHERE amount_paid = 0");
    echo "✓ Updated fee statuses\n\n";
    
    echo "✅ Migration completed successfully!\n";
    echo "\nYou can now:\n";
    echo "1. Record payments for fees\n";
    echo "2. Track payment history\n";
    echo "3. View accurate balances\n";
    
} catch (PDOException $e) {
    echo "❌ Migration failed: " . $e->getMessage() . "\n";
    exit(1);
}
?>
