<?php
/**
 * Migration: Add payment frequency support for feeding system
 * This allows students to pay weekly or monthly for feeding
 */

require_once __DIR__ . '/../config/database.php';

try {
    echo "Starting feeding payment frequency migration...\n";
    
    // Add payment_frequency column to students table
    echo "Adding payment_frequency column to students table...\n";
    $conn->exec("
        ALTER TABLE students 
        ADD COLUMN IF NOT EXISTS feeding_payment_frequency ENUM('weekly', 'monthly') DEFAULT 'weekly' AFTER custom_feeding_fee
    ");
    echo "✓ Added feeding_payment_frequency column\n";
    
    // Add monthly_fee_balance column to track remaining balance for monthly payers
    echo "Adding monthly_fee_balance column to students table...\n";
    $conn->exec("
        ALTER TABLE students 
        ADD COLUMN IF NOT EXISTS feeding_monthly_balance DECIMAL(10,2) DEFAULT 0.00 AFTER feeding_payment_frequency
    ");
    echo "✓ Added feeding_monthly_balance column\n";
    
    // Add last_monthly_payment_date to track when monthly payment was made
    echo "Adding last_monthly_payment_date column to students table...\n";
    $conn->exec("
        ALTER TABLE students 
        ADD COLUMN IF NOT EXISTS feeding_last_monthly_payment DATE NULL AFTER feeding_monthly_balance
    ");
    echo "✓ Added feeding_last_monthly_payment column\n";
    
    echo "\n✅ Migration completed successfully!\n";
    echo "\nFeeding Payment Frequency Feature:\n";
    echo "- Students can now pay weekly (daily) or monthly\n";
    echo "- Monthly payments are automatically distributed across 5 days per week\n";
    echo "- System tracks remaining balance for monthly payers\n";
    
} catch (PDOException $e) {
    echo "❌ Migration failed: " . $e->getMessage() . "\n";
    exit(1);
}
