<?php
/**
 * Migration: Add custom feeding fee field to students table
 * This allows individual students to have different feeding fees (e.g., bus students)
 */

require_once __DIR__ . '/../api/config.php';

try {
    $conn = new PDO("mysql:host=" . DB_HOST . ";dbname=" . DB_NAME, DB_USER, DB_PASS);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    echo "Starting migration: Add custom feeding fee field...\n";
    
    // Add custom_feeding_fee column to students table
    $conn->exec("
        ALTER TABLE students 
        ADD COLUMN IF NOT EXISTS custom_feeding_fee DECIMAL(10,2) NULL DEFAULT NULL COMMENT 'Custom daily feeding fee for this student (overrides class default)',
        ADD COLUMN IF NOT EXISTS feeding_fee_note VARCHAR(255) NULL DEFAULT NULL COMMENT 'Note about custom fee (e.g., Bus, Special diet)'
    ");
    
    echo "✓ Added custom_feeding_fee and feeding_fee_note columns to students table\n";
    
    // Add custom_fee column to feeding_records table
    $conn->exec("
        ALTER TABLE feeding_records 
        ADD COLUMN IF NOT EXISTS custom_fee DECIMAL(10,2) NULL DEFAULT NULL COMMENT 'Custom fee used for this record'
    ");
    
    echo "✓ Added custom_fee column to feeding_records table\n";
    
    echo "\n✅ Migration completed successfully!\n";
    
} catch(PDOException $e) {
    echo "❌ Migration failed: " . $e->getMessage() . "\n";
    exit(1);
}
?>
