-- Fix fees table to properly track amount_paid
-- This ensures payments are tracked separately from total fee amount

-- Add amount_paid column if it doesn't exist
ALTER TABLE fees 
ADD COLUMN IF NOT EXISTS amount_paid DECIMAL(10,2) DEFAULT 0.00 AFTER amount;

-- Add balance column if it doesn't exist
ALTER TABLE fees 
ADD COLUMN IF NOT EXISTS balance DECIMAL(10,2) DEFAULT 0.00 AFTER amount_paid;

-- Add payment_history column if it doesn't exist
ALTER TABLE fees 
ADD COLUMN IF NOT EXISTS payment_history JSON NULL AFTER balance;

-- Update existing records to set balance = amount - amount_paid
UPDATE fees 
SET balance = amount - COALESCE(amount_paid, 0)
WHERE balance IS NULL OR balance = 0;

-- Update status based on actual payments
UPDATE fees 
SET status = CASE 
    WHEN amount_paid >= amount THEN 'Paid'
    WHEN amount_paid > 0 THEN 'Partial'
    ELSE 'Unpaid'
END
WHERE amount_paid IS NOT NULL;
