<?php
/**
 * Fix Missing Feeding Columns in Production Database
 * Run this file once: https://4102009823.ceiscy.com/school/database/fix_feeding_columns.php
 */

require_once __DIR__ . '/../config/database.php';

header('Content-Type: application/json');

try {
    $pdo = getDBConnection();
    
    $results = [];
    
    // Check and add feeding_weekly_balance column to students table
    $checkColumn = $pdo->query("SHOW COLUMNS FROM students LIKE 'feeding_weekly_balance'")->fetch();
    if (!$checkColumn) {
        $pdo->exec("ALTER TABLE students ADD COLUMN feeding_weekly_balance DECIMAL(10,2) DEFAULT 0.00 AFTER feeding_balance");
        $results[] = "✅ Added feeding_weekly_balance column to students table";
    } else {
        $results[] = "✓ feeding_weekly_balance column already exists";
    }
    
    // Check and add feeding_payment_frequency column to students table
    $checkColumn = $pdo->query("SHOW COLUMNS FROM students LIKE 'feeding_payment_frequency'")->fetch();
    if (!$checkColumn) {
        $pdo->exec("ALTER TABLE students ADD COLUMN feeding_payment_frequency ENUM('daily', 'weekly', 'monthly', 'termly') DEFAULT 'daily' AFTER feeding_weekly_balance");
        $results[] = "✅ Added feeding_payment_frequency column to students table";
    } else {
        $results[] = "✓ feeding_payment_frequency column already exists";
    }
    
    // Check and add custom_feeding_fee column to students table
    $checkColumn = $pdo->query("SHOW COLUMNS FROM students LIKE 'custom_feeding_fee'")->fetch();
    if (!$checkColumn) {
        $pdo->exec("ALTER TABLE students ADD COLUMN custom_feeding_fee DECIMAL(10,2) NULL AFTER feeding_payment_frequency");
        $results[] = "✅ Added custom_feeding_fee column to students table";
    } else {
        $results[] = "✓ custom_feeding_fee column already exists";
    }
    
    // Check and add feeding_scholarship_percentage column to students table
    $checkColumn = $pdo->query("SHOW COLUMNS FROM students LIKE 'feeding_scholarship_percentage'")->fetch();
    if (!$checkColumn) {
        $pdo->exec("ALTER TABLE students ADD COLUMN feeding_scholarship_percentage INT DEFAULT 0 AFTER custom_feeding_fee");
        $results[] = "✅ Added feeding_scholarship_percentage column to students table";
    } else {
        $results[] = "✓ feeding_scholarship_percentage column already exists";
    }
    
    // Check and add feeding_notes column to students table
    $checkColumn = $pdo->query("SHOW COLUMNS FROM students LIKE 'feeding_notes'")->fetch();
    if (!$checkColumn) {
        $pdo->exec("ALTER TABLE students ADD COLUMN feeding_notes TEXT NULL AFTER feeding_scholarship_percentage");
        $results[] = "✅ Added feeding_notes column to students table";
    } else {
        $results[] = "✓ feeding_notes column already exists";
    }
    
    // Verify all columns exist
    $columns = $pdo->query("SHOW COLUMNS FROM students")->fetchAll(PDO::FETCH_COLUMN);
    $requiredColumns = [
        'feeding_balance',
        'feeding_weekly_balance',
        'feeding_payment_frequency',
        'custom_feeding_fee',
        'feeding_scholarship_percentage',
        'feeding_notes'
    ];
    
    $missingColumns = array_diff($requiredColumns, $columns);
    
    if (empty($missingColumns)) {
        $results[] = "✅ All feeding columns are present!";
        $success = true;
    } else {
        $results[] = "⚠️ Still missing columns: " . implode(', ', $missingColumns);
        $success = false;
    }
    
    echo json_encode([
        'success' => $success,
        'message' => 'Database migration completed',
        'results' => $results,
        'columns' => $columns
    ], JSON_PRETTY_PRINT);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage(),
        'trace' => $e->getTraceAsString()
    ], JSON_PRETTY_PRINT);
}
