-- Create feeding system tables

-- Table for class feeding fees
CREATE TABLE IF NOT EXISTS class_feeding_fees (
    id INT AUTO_INCREMENT PRIMARY KEY,
    class_name VARCHAR(50) NOT NULL UNIQUE,
    daily_fee DECIMAL(10,2) NOT NULL DEFAULT 0.00,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);

-- Table for daily feeding records
CREATE TABLE IF NOT EXISTS feeding_records (
    id INT AUTO_INCREMENT PRIMARY KEY,
    student_id VARCHAR(20) NOT NULL,
    student_name VARCHAR(100) NOT NULL,
    class_name VARCHAR(50) NOT NULL,
    feeding_date DATE NOT NULL,
    is_present BOOLEAN DEFAULT FALSE,
    has_paid BOOLEAN DEFAULT FALSE,
    amount_paid DECIMAL(10,2) DEFAULT 0.00,
    recorded_by VARCHAR(100),
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    UNIQUE KEY unique_student_date (student_id, feeding_date),
    INDEX idx_date_class (feeding_date, class_name),
    INDEX idx_student_date (student_id, feeding_date)
);

-- Insert default feeding fees for common classes
INSERT IGNORE INTO class_feeding_fees (class_name, daily_fee) VALUES
('Creche', 5.00),
('Nursery 1', 5.50),
('Nursery 2', 5.50),
('KG 1', 6.00),
('KG 2', 6.00),
('Class 1', 6.50),
('Class 2', 6.50),
('Class 3', 7.00),
('Class 4', 7.00),
('Class 5', 7.50),
('Class 6', 7.50),
('Basic 1', 6.50),
('Basic 2', 6.50),
('Basic 3', 7.00),
('Basic 4', 7.00),
('Basic 5', 7.50),
('Basic 6', 7.50),
('JHS 1', 8.00),
('JHS 2', 8.00),
('JHS 3', 8.50);