<?php
/**
 * Migration: Add notes column to feeding_records table
 */

require_once __DIR__ . '/../config/database.php';

try {
    echo "Adding notes column to feeding_records table...\n";
    
    $conn->exec("
        ALTER TABLE feeding_records 
        ADD COLUMN IF NOT EXISTS notes TEXT NULL AFTER amount_paid
    ");
    
    echo "✅ Notes column added successfully!\n";
    echo "\nNow you can add notes for each feeding record (e.g., reason for non-payment)\n";
    
} catch (PDOException $e) {
    if (strpos($e->getMessage(), 'Duplicate column name') !== false) {
        echo "⚠️  Notes column already exists\n";
    } else {
        echo "❌ Error: " . $e->getMessage() . "\n";
        exit(1);
    }
}
